<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // ✅ إضافة العمود is_monthly كـ BOOLEAN مع قيمة افتراضية false
            if (!Schema::hasColumn('deductions', 'is_monthly')) {
                $table->boolean('is_monthly')->default(false)->after('status'); // بعد status أو في أي مكان مناسب
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // ✅ حذف العمود is_monthly
            if (Schema::hasColumn('deductions', 'is_monthly')) {
                $table->dropColumn('is_monthly');
            }
        });
    }
};