<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // ✅ تغيير نوع العمود is_monthly إلى BOOLEAN مع قيمة افتراضية false
            if (Schema::hasColumn('deductions', 'is_monthly')) {
                $table->boolean('is_monthly')->default(false)->change();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // ✅ تغيير نوع العمود is_monthly إلى VARCHAR(255) مثلاً (القيمة القديمة)
            if (Schema::hasColumn('deductions', 'is_monthly')) {
                $table->string('is_monthly', 255)->nullable()->change(); // أو النوع القديم
            }
        });
    }
};