<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // ✅ التأكد من وجود العمود قبل محاولة حذفه
            if (Schema::hasColumn('deductions', 'method')) {
                $table->dropColumn('method');
            }
            if (Schema::hasColumn('deductions', 'frequency')) {
                $table->dropColumn('frequency');
            }
            if (Schema::hasColumn('deductions', 'is_monthly')) {
                $table->dropColumn('is_monthly');
            }
            if (Schema::hasColumn('deductions', 'end_date')) {
                $table->dropColumn('end_date');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // ⚠️ التراجع عن الحذف صعب شوية لإننا مش عارفين النوع الدقيق للأعمدة.
        // ✅ الأسهل إننا نسيبهم كـ VARCHAR أو DATE حسب الحاجة.
        Schema::table('deductions', function (Blueprint $table) {
            // ✅ إعادة إنشاء الأعمدة المحذوفة (إن كانت مش موجودة)
            if (!Schema::hasColumn('deductions', 'method')) {
                 $table->string('method', 50)->nullable(); // أو النوع اللي كان عليه الأصل
            }
            if (!Schema::hasColumn('deductions', 'frequency')) {
                 $table->string('frequency', 50)->nullable(); // أو النوع اللي كان عليه الأصل
            }
            if (!Schema::hasColumn('deductions', 'is_monthly')) {
                 $table->boolean('is_monthly')->default(false); // أو النوع اللي كان عليه الأصل
            }
            if (!Schema::hasColumn('deductions', 'end_date')) {
                 $table->date('end_date')->nullable(); // أو النوع اللي كان عليه الأصل
            }
        });
    }
};