<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the column is ENUM first (requires Doctrine DBAL, might be complex)
        // Simpler approach if it's just a VARCHAR or if you know it's an ENUM needing update:
        // This assumes it's an ENUM and updates it. Be careful with ENUM changes.

        // IMPORTANT: Directly modifying ENUM definitions can be tricky with raw SQL in Laravel Migrations.
        // The safest way often involves recreating the column or using raw SQL carefully.
        // Let's assume it's an ENUM and needs updating.

        // Example using raw SQL (adjust the ENUM list as needed to include ALL values you use):
        // Check your current ENUM values first!
        // This example adds 'subscription', 'penalty', 'deduction', 'absence', 'cash', 'in_kind'
        // Make sure the list inside ENUM(...) matches exactly what you need AND what's currently there.
        // Replace 'existing_value1', 'existing_value2' with actual current values from DESCRIBE/SHOW CREATE TABLE.
        // IF YOU ARE UNSURE, USE OPTION 2 BELOW.

        /*
        DB::statement("ALTER TABLE deductions MODIFY COLUMN type ENUM(
            'tax', 'insurance', 'loan', 'fine', 'other',
            'cash', 'in_kind', 'deduction', 'penalty', 'subscription', 'absence'
        ) NOT NULL DEFAULT 'other'");
        */

        // --- OR, if you are unsure about the current ENUM values ---
        // --- OR, if it's better suited as a VARCHAR ---
        // Change the column type to VARCHAR(50) to match the original migration intent and avoid ENUM limitations.
         Schema::table('deductions', function (Blueprint $table) {
             // This changes the type column to VARCHAR(50), removing ENUM restrictions.
             // This is generally safer and more flexible for dynamic lists.
             $table->string('type', 50)->change(); // Ensure length matches original definition
         });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reversing a VARCHAR change back to a specific ENUM is complex without knowing the original ENUM values.
        // If you changed it to VARCHAR, you might leave it as VARCHAR, or recreate the original ENUM.
        // If you used raw SQL to change ENUM, you'd need the original ENUM definition here.
        // For VARCHAR change:
        // Schema::table('deductions', function (Blueprint $table) {
        //     // You would need to know the exact original definition to reverse this accurately.
        //     // E.g., if it was originally ENUM, you'd need to redefine it exactly.
        //     // This is just an example placeholder.
        //     // $table->enum('type', ['tax', 'insurance', 'loan', 'fine', 'other'])->change();
        // });

         // If changed to VARCHAR, maybe just acknowledge it stays VARCHAR or revert to a known state.
         // Placeholder or comment:
         // Schema::table('deductions', function (Blueprint $table) {
         //     // Reverting VARCHAR change requires knowing original type. Leaving as VARCHAR for now.
         // });
    }
};