<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة الحقل cancelled_by (رقم صحيح، يمكن أن يكون فارغًا)
            // ✅ تم تغيير 'rejected_at' إلى 'activated_at' لأن الحقل الأخير غير موجود
            $table->unsignedBigInteger('cancelled_by')->nullable()->after('activated_at'); 
            // إضافة الحقل cancelled_at (تاريخ/وقت، يمكن أن يكون فارغًا)
            $table->timestamp('cancelled_at')->nullable()->after('cancelled_by'); 

            // (اختياري) إضافة علاقة خارجية (Foreign Key) تشير إلى جدول users
            // تأكد من أن جدول users وجدول loans تم إنشاؤه قبل هذا الترحيل
            $table->foreign('cancelled_by')->references('id')->on('users')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العلاقة (Foreign Key) أولاً قبل حذف الحقل
            $table->dropForeign(['cancelled_by']);
            // حذف الحقول
            $table->dropColumn(['cancelled_by', 'cancelled_at']);
        });
    }
};