<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة العمود activated_by إذا لم يكن موجودًا بالفعل
            if (!Schema::hasColumn('loans', 'activated_by')) {
                $table->foreignId('activated_by')->nullable()->constrained('users')->nullOnDelete()->after('approved_at');
            }
            // إضافة العمود activated_at إذا لم يكن موجودًا بالفعل
            if (!Schema::hasColumn('loans', 'activated_at')) {
                $table->timestamp('activated_at')->nullable()->after('activated_by');
            }
        });
    }

    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العمود activated_at أولاً (لأن activated_by هو FK)
            if (Schema::hasColumn('loans', 'activated_at')) {
                $table->dropColumn('activated_at');
            }
            // حذف العمود activated_by
            if (Schema::hasColumn('loans', 'activated_by')) {
                $table->dropColumn('activated_by');
            }
        });
    }
};