<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة العمود remaining_amount إذا لم يكن موجودًا بالفعل (ل以防万一)
            if (!Schema::hasColumn('loans', 'remaining_amount')) {
                $table->decimal('remaining_amount', 10, 2)->default(0.00)->after('paid_amount'); // يمكنك تعديل 'after' حسب الحاجة
            }
        });
    }

    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العمود remaining_amount
            if (Schema::hasColumn('loans', 'remaining_amount')) {
                $table->dropColumn('remaining_amount');
            }
        });
    }
};