<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة العمود paid_amount إذا لم يكن موجودًا بالفعل (ل以防万一)
            if (!Schema::hasColumn('loans', 'paid_amount')) {
                $table->decimal('paid_amount', 10, 2)->default(0.00)->after('status'); // يمكنك تعديل 'after' حسب الحاجة
            }
        });
    }

    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العمود paid_amount
            if (Schema::hasColumn('loans', 'paid_amount')) {
                $table->dropColumn('paid_amount');
            }
        });
    }
};