<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة العمود reason إذا لم يكن موجودًا بالفعل (ل以防万一)
            if (!Schema::hasColumn('loans', 'reason')) {
                $table->text('reason')->nullable()->after('end_date'); // يمكنك تعديل 'after' حسب الحاجة
            }
        });
    }

    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العمود reason
            if (Schema::hasColumn('loans', 'reason')) {
                $table->dropColumn('reason');
            }
        });
    }
};