<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة العمود loan_type
            $table->string('loan_type')->nullable(); // أو استخدم enum إذا كانت القيم محددة
            // مثال على enum:
            // $table->enum('loan_type', ['personal', 'car', 'house', 'other'])->default('personal');
        });
    }

    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العمود loan_type
            $table->dropColumn('loan_type');
        });
    }
};