<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loan_installments', function (Blueprint $table) {
            // إضافة الحقل payment_method بعد الحقل status
            $table->enum('payment_method', ['cash', 'bank_transfer', 'check', 'deduction'])->nullable()->after('paid_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loan_installments', function (Blueprint $table) {
            // حذف الحقل payment_method عند التراجع
            $table->dropColumn('payment_method');
        });
    }
};