<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // إذا كان الحقل موجود بالفعل
        if (Schema::hasColumn('employees', 'monthly_leave_days_allowed')) {
            Schema::table('employees', function (Blueprint $table) {
                $table->integer('monthly_leave_days_allowed')->default(2)->change();
            });

            // تحديث جميع الموظفين الحاليين إذا لم يكن لديهم قيمة
            DB::table('employees')
                ->whereNull('monthly_leave_days_allowed')
                ->update(['monthly_leave_days_allowed' => 2]);

        } else {
            // إذا كان الحقل غير موجود، إنشاءه
            Schema::table('employees', function (Blueprint $table) {
                $table->integer('monthly_leave_days_allowed')->default(2);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // إعادة الحقل إلى الحالة السابقة أو حذفه
        if (Schema::hasColumn('employees', 'monthly_leave_days_allowed')) {
            Schema::table('employees', function (Blueprint $table) {
                $table->dropColumn('monthly_leave_days_allowed');
            });
        }
    }
};
