<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // إضافة العمود rejected_by إذا لم يكن موجودًا
            if (!Schema::hasColumn('leaves', 'rejected_by')) {
                $table->unsignedBigInteger('rejected_by')->nullable()->after('approved_by');
            }

            // إضافة العمود rejected_at إذا لم يكن موجودًا
            if (!Schema::hasColumn('leaves', 'rejected_at')) {
                $table->timestamp('rejected_at')->nullable()->after('rejected_by');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // إزالة الأعمدة إذا كانت موجودة
            if (Schema::hasColumn('leaves', 'rejected_by')) {
                $table->dropColumn('rejected_by');
            }

            if (Schema::hasColumn('leaves', 'rejected_at')) {
                $table->dropColumn('rejected_at');
            }
        });
    }
};
