<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // إضافة العمود contact_details فقط إذا لم يكن موجودًا
            if (!Schema::hasColumn('leaves', 'contact_details')) {
                $table->text('contact_details')->nullable()->after('reason');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // إزالة العمود contact_details إذا كان موجودًا
            if (Schema::hasColumn('leaves', 'contact_details')) {
                $table->dropColumn('contact_details');
            }
        });
    }
};
