<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // التأكد من أن الحقل موجود قبل محاولة تعديله
        if (Schema::hasColumn('employees', 'monthly_leave_days_allowed')) {
            Schema::table('employees', function (Blueprint $table) {
                // تعديل الحقل لزيادة الحد الأقصى (مثلاً إلى 30 يومًا شهريًا)
                $table->integer('monthly_leave_days_allowed')->default(2)->change();
                // يمكنك أيضًا تعديل التعليق أو نوع الحقل حسب الحاجة
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // التراجع عن التعديل (إذا لزم)
        if (Schema::hasColumn('employees', 'monthly_leave_days_allowed')) {
            Schema::table('employees', function (Blueprint $table) {
                // مثلاً: تغيير القيمة الافتراضية فقط
                $table->integer('monthly_leave_days_allowed')->default(2)->change();
            });
        }
    }
};