<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // إضافة العمود فقط إذا لم يكن موجودًا
            if (!Schema::hasColumn('leaves', 'days_count')) {
                $table->integer('days_count')->default(0)->after('end_date');
            }
        });
    }

    public function down(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // إزالة العمود إذا كان موجودًا
            if (Schema::hasColumn('leaves', 'days_count')) {
                $table->dropColumn('days_count');
            }
        });
    }
};
