<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            // إضافة العمود الجديد installment_count
            // للتأكد إنه يقبل القيمة الافتراضية 0
            if (!Schema::hasColumn('loans', 'installments_count')) {
                $table->integer('installments_count')
                      ->default(0)
                      ->after('total_amount');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            // حذف العمود عند التراجع عن المايجريشن
            if (Schema::hasColumn('loans', 'installment_count')) {
                $table->dropColumn('installment_count');
            }
        });
    }
};
