<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * إضافة أوقات الحضور والانصراف المجدولة إلى جدول الموظفين.
     */
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            // فقط أضف الحقول إذا لم تكن موجودة
            if (!Schema::hasColumn('employees', 'scheduled_check_in')) {
                $table->time('scheduled_check_in')->nullable()->after('status');
            }

            if (!Schema::hasColumn('employees', 'scheduled_check_out')) {
                $table->time('scheduled_check_out')->nullable()->after('scheduled_check_in');
            }
        });
    }

    /**
     * التراجع عن إضافة الأعمدة.
     */
    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            // فقط احذف إذا كانت موجودة
            if (Schema::hasColumn('employees', 'scheduled_check_in')) {
                $table->dropColumn('scheduled_check_in');
            }

            if (Schema::hasColumn('employees', 'scheduled_check_out')) {
                $table->dropColumn('scheduled_check_out');
            }
        });
    }
};