<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * إضافة حقل المؤهل العلمي للموظفين.
     *
     * هذه الهجرة تضيف عمود qualification إلى جدول employees
     * فقط إذا لم يكن موجودًا بالفعل.
     */
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            // ✅ التحقق من عدم وجود العمود قبل الإضافة
            if (!Schema::hasColumn('employees', 'qualification')) {
                $table->string('qualification')->nullable()->after('status');
            }
        });
    }

    /**
     * التراجع عن إضافة حقل المؤهل العلمي.
     */
    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            // ✅ التحقق من وجود العمود قبل الحذف
            if (Schema::hasColumn('employees', 'qualification')) {
                $table->dropColumn('qualification');
            }
        });
    }
};