<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique(); // مثلاً: 'default_currency'
            $table->string('value')->nullable(); // مثلاً: 'EGP'
            $table->string('description')->nullable(); // مثلاً: 'العملة الافتراضية للنظام'
            $table->timestamps();
        });

        // إدخال العملة الافتراضية بعد إنشاء الجدول
        DB::table('settings')->insert([
            'key' => 'default_currency',
            'value' => 'EGP', // تعيين الجنيه المصري كعملة افتراضية
            'description' => 'العملة الافتراضية المستخدمة في النظام',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};