<?php

// File: database/migrations/xxxx_xx_xx_xxxxxx_add_age_qualification_cv_files_to_employees_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->integer('age')->nullable();
            $table->string('qualification')->nullable();
            $table->json('cv_files')->nullable(); // لتخزين مسارات الملفات كـ JSON
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn(['age', 'qualification', 'cv_files']);
        });
    }
};

// اسم الكلاس يجب أن يكون AddAgeQualificationCvFilesToEmployeesTable
class AddAgeQualificationCvFilesToEmployeesTable extends Migration
{
    // هذه الكلاس لا حاجة لها الآن لأننا استخدمنا anonymous class أعلاه
    // لكن Laravel قد يبحث عن هذا الاسم القديم أحيانًا
    // لذلك نضعها فارغة للتوافق
}