
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddScheduledTimesToAttendancesTable extends Migration
{
    public function up()
    {
        Schema::table('attendances', function (Blueprint $table) {
            // إضافة الأعمدة الجديدة
            $table->time('scheduled_check_in')->nullable()->after('check_out'); // أو بعد أي عمود مناسب
            $table->time('scheduled_check_out')->nullable()->after('scheduled_check_in');
        });
    }

    public function down()
    {
        Schema::table('attendances', function (Blueprint $table) {
            // حذف الأعمدة في حالة التراجع
            $table->dropColumn(['scheduled_check_in', 'scheduled_check_out']);
        });
    }
}