<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // لو الجدول موجود
        if (Schema::hasTable('asset_assignments')) {
            Schema::table('asset_assignments', function (Blueprint $table) {
                // إضافة العمود role_id لو مش موجود
                if (!Schema::hasColumn('asset_assignments', 'role_id')) {
                    $table->unsignedBigInteger('role_id')->nullable();
                }

                // إضافة FK مباشرة (Laravel هيهاندل لو موجود أو لا)
                $table->foreign('role_id')
                      ->references('id')
                      ->on('roles')
                      ->nullOnDelete();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('asset_assignments')) {
            Schema::table('asset_assignments', function (Blueprint $table) {
                if (Schema::hasColumn('asset_assignments', 'role_id')) {
                    $table->dropForeign(['role_id']);
                    $table->dropColumn('role_id');
                }
            });
        }
    }
};
