<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('training_programs') && !Schema::hasColumn('training_programs', 'role_id')) {
            Schema::table('training_programs', function (Blueprint $table) {
                $table->foreignId('role_id')->nullable()->constrained('roles')->nullOnDelete()->after('id');
            });
        }

        if (Schema::hasTable('employee_training') && !Schema::hasColumn('employee_training', 'role_id')) {
            Schema::table('employee_training', function (Blueprint $table) {
                $table->foreignId('role_id')->nullable()->constrained('roles')->nullOnDelete()->after('employee_id');
            });
        }

        if (Schema::hasTable('training_progress') && !Schema::hasColumn('training_progress', 'role_id')) {
            Schema::table('training_progress', function (Blueprint $table) {
                $table->foreignId('role_id')->nullable()->constrained('roles')->nullOnDelete()->after('employee_id');
            });
        }
    }

    public function down(): void
    {
        Schema::table('training_programs', function (Blueprint $table) {
            $table->dropColumn('role_id');
        });

        Schema::table('employee_training', function (Blueprint $table) {
            $table->dropColumn('role_id');
        });

        Schema::table('training_progress', function (Blueprint $table) {
            $table->dropColumn('role_id');
        });
    }
};
