<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // FK: employees.user_id → users.id
        Schema::table('employees', function (Blueprint $table) {
            $table->foreign('user_id', 'fk_employees_user_id')
                  ->references('id')
                  ->on('users')
                  ->nullOnDelete();
        });

        // FK: users.employee_id → employees.id
        Schema::table('users', function (Blueprint $table) {
            $table->foreign('employee_id', 'fk_users_employee_id')
                  ->references('id')
                  ->on('employees')
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropForeign('fk_employees_user_id');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign('fk_users_employee_id');
        });
    }
};
