<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_maintenances', function (Blueprint $table) {
            $table->id();
            
            // ربط الصيانة بالعنصر
            $table->unsignedBigInteger('asset_id');
            $table->foreign('asset_id')->references('id')->on('assets')->onDelete('cascade');
            
            $table->string('title'); // عنوان الصيانة
            $table->text('description')->nullable(); // وصف الصيانة
            $table->date('maintenance_date'); // تاريخ الصيانة
            $table->enum('status', ['pending', 'in_progress', 'completed', 'cancelled'])->default('pending');
            $table->decimal('cost', 10, 2)->default(0); // تكلفة الصيانة
            $table->unsignedBigInteger('performed_by')->nullable(); // المستخدم الذي قام بالصيانة
            $table->foreign('performed_by')->references('id')->on('users')->onDelete('set null');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_maintenances');
    }
};
