<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('asset_assignments')) {
            if (!Schema::hasColumn('asset_assignments', 'role_id')) {
                Schema::table('asset_assignments', function (Blueprint $table) {
                    $table->unsignedBigInteger('role_id')->nullable();
                    $table->foreign('role_id')
                          ->references('id')
                          ->on('roles')
                          ->nullOnDelete();
                });
            }
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('asset_assignments') && Schema::hasColumn('asset_assignments', 'role_id')) {
            Schema::table('asset_assignments', function (Blueprint $table) {
                $table->dropForeign(['role_id']);
                $table->dropColumn('role_id');
            });
        }
    }
};
