<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // تحديث جدول البرامج التدريبية
        if (Schema::hasTable('training_programs')) {
            Schema::table('training_programs', function (Blueprint $table) {
                if (!Schema::hasColumn('training_programs', 'completion_percentage')) {
                    $table->decimal('completion_percentage', 5, 2)->default(0)->after('status');
                }
                
                if (!Schema::hasColumn('training_programs', 'deleted_at')) {
                    $table->softDeletes()->after('updated_at');
                }

                if (!Schema::hasColumn('training_programs', 'category')) {
                    $table->string('category')->default('technical')->after('description');
                }

                if (!Schema::hasColumn('training_programs', 'duration_unit')) {
                    $table->string('duration_unit')->default('hours')->after('duration');
                }
            });

            // إضافة FK إلى roles فقط إذا وجد الجدول
            if (Schema::hasTable('roles') && !Schema::hasColumn('training_programs', 'role_id')) {
                Schema::table('training_programs', function (Blueprint $table) {
                    $table->foreignId('role_id')
                          ->nullable()
                          ->constrained('roles')
                          ->nullOnDelete()
                          ->after('id');
                });
            }
        }

        // تحديث جدول التسجيلات
        if (Schema::hasTable('employee_training')) {
            Schema::table('employee_training', function (Blueprint $table) {
                if (!Schema::hasColumn('employee_training', 'deleted_at')) {
                    $table->softDeletes()->after('updated_at');
                }

                if (!Schema::hasColumn('employee_training', 'score')) {
                    $table->integer('score')->nullable()->after('status');
                }
            });

            // إضافة FK إلى roles فقط إذا وجد الجدول
            if (Schema::hasTable('roles') && !Schema::hasColumn('employee_training', 'role_id')) {
                Schema::table('employee_training', function (Blueprint $table) {
                    $table->foreignId('role_id')
                          ->nullable()
                          ->constrained('roles')
                          ->nullOnDelete()
                          ->after('employee_id');
                });
            }
        }

        // تحديث جدول التقدم
        if (Schema::hasTable('training_progress')) {
            Schema::table('training_progress', function (Blueprint $table) {
                if (!Schema::hasColumn('training_progress', 'deleted_at')) {
                    $table->softDeletes()->after('updated_at');
                }
            });

            // إضافة FK إلى roles فقط إذا وجد الجدول
            if (Schema::hasTable('roles') && !Schema::hasColumn('training_progress', 'role_id')) {
                Schema::table('training_progress', function (Blueprint $table) {
                    $table->foreignId('role_id')
                          ->nullable()
                          ->constrained('roles')
                          ->nullOnDelete()
                          ->after('employee_id');
                });
            }
        }
    }

    public function down(): void
    {
        // لا حاجة لإزالة الأعمدة
    }
};
