<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            if (!Schema::hasColumn('deductions', 'frequency')) {
                $table->string('frequency')->default('monthly')->after('amount');
            }

            if (!Schema::hasColumn('deductions', 'deduction_type')) {
                $table->string('deduction_type')->default('other')->after('employee_id');
            }

            if (!Schema::hasColumn('deductions', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('end_date');
            }
        });
    }

    public function down(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            if (Schema::hasColumn('deductions', 'frequency')) {
                $table->dropColumn('frequency');
            }
            if (Schema::hasColumn('deductions', 'deduction_type')) {
                $table->dropColumn('deduction_type');
            }
            if (Schema::hasColumn('deductions', 'is_active')) {
                $table->dropColumn('is_active');
            }
        });
    }
};
