<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $columns = [
                'employee_id' => fn($t) => $t->string('employee_id')->unique()->after('id'),
                'name' => fn($t) => $t->string('name')->after('employee_id'),
                'email' => fn($t) => $t->string('email')->nullable()->unique()->after('name'),
                'phone' => fn($t) => $t->string('phone')->nullable()->after('email'),
                'position' => fn($t) => $t->string('position')->nullable()->after('phone'),
                'department' => fn($t) => $t->string('department')->nullable()->after('position'),
                'hire_date' => fn($t) => $t->date('hire_date')->nullable()->after('department'),
                'salary' => fn($t) => $t->decimal('salary', 10, 2)->default(0)->after('hire_date'),
                'status' => fn($t) => $t->string('status')->default('active')->after('salary'),
                'address' => fn($t) => $t->text('address')->nullable()->after('status'),
                'photo' => fn($t) => $t->string('photo')->nullable()->after('address'),
                'birth_date' => fn($t) => $t->date('birth_date')->nullable()->after('photo'),
                'national_id' => fn($t) => $t->string('national_id')->nullable()->after('birth_date'),
                'bank_account' => fn($t) => $t->string('bank_account')->nullable()->after('national_id'),
                'emergency_contact' => fn($t) => $t->string('emergency_contact')->nullable()->after('bank_account'),
            ];

            foreach ($columns as $name => $callback) {
                if (!Schema::hasColumn('employees', $name)) {
                    $callback($table);
                }
            }
        });
    }

    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $columns = [
                'employee_id','name','email','phone','position','department','hire_date',
                'salary','status','address','photo','birth_date','national_id','bank_account','emergency_contact'
            ];
            foreach ($columns as $column) {
                if (Schema::hasColumn('employees', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
