<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('loan_installments')) {
            Schema::create('loan_installments', function (Blueprint $table) {
                $table->id();

                // ربط القسط بالقرض
                $table->foreignId('loan_id')
                      ->constrained('loans')
                      ->cascadeOnDelete();

                // رقم القسط لتحديد ترتيبه ضمن القرض
                $table->integer('installment_number');

                $table->date('due_date');
                $table->date('paid_date')->nullable();
                $table->decimal('amount', 10, 2);

                // حالة القسط
                $table->enum('status', ['pending', 'paid', 'overdue', 'cancelled'])->default('pending');

                $table->text('notes')->nullable();
                $table->timestamps();

                // فهرس للاستعلامات السريعة حسب الحالة والتاريخ
                $table->index(['status', 'due_date']);

                // تأكيد أن رقم القسط فريد لكل قرض
                $table->unique(['loan_id', 'installment_number'], 'loan_installment_unique');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('loan_installments');
    }
};
