<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();

            // ربط الحضور بالموظف
            $table->foreignId('employee_id')
                  ->constrained('employees')
                  ->cascadeOnDelete(); // حذف الحضور عند حذف الموظف

            $table->date('date'); // تاريخ الحضور
            $table->time('check_in')->nullable(); // وقت الدخول
            $table->time('check_out')->nullable(); // وقت الخروج

            // حالة الحضور
            $table->enum('status', ['present', 'absent', 'late', 'leave'])->default('present');

            $table->text('notes')->nullable(); // ملاحظات
            $table->timestamps();

            // فهرس لتسريع البحث عن حضور الموظف في يوم معين
            $table->unique(['employee_id', 'date'], 'employee_date_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
