<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();

            // ربط الراتب بالموظف
            $table->foreignId('employee_id')
                  ->constrained('employees')
                  ->cascadeOnDelete(); // حذف الرواتب عند حذف الموظف

            $table->integer('month');
            $table->integer('year');
            $table->decimal('basic_salary', 10, 2);
            $table->decimal('allowances', 10, 2)->default(0);
            $table->decimal('deductions', 10, 2)->default(0);
            $table->decimal('net_salary', 10, 2);

            // ✅ إضافة الحقل الجديد لتخزين الرصيد قبل الخصم (يمكن أن يكون سالبًا)
            $table->integer('leave_balance_before_deduction')->default(0)->comment('رصيد الإجازات قبل خصم الإجازات لهذا الشهر (يمكن أن يكون سالبًا إذا تجاوزت الإجازة الرصيد المتاح)');

            // ✅ إضافة الحقل الجديد لتخزين مبلغ الخصم المالي من الراتب بسبب الإجازات الزائدة
            $table->decimal('leave_deduction_amount', 10, 2)->default(0.00)->comment('المبلغ المخصوم من الراتب ناتج عن استخدام إجازات تجاوزت الرصيد المتاح');

            // ✅ إضافة الحقل الجديد لتخزين عدد الأيام الممنوحة في هذا الشهر
            $table->integer('leave_granted_this_month')->default(0)->comment('عدد أيام الإجازات الممنوحة في هذا الشهر');

            // ✅ تحديث تعليق الحقل الحالي ليعكس وظيفته بدقة (الرصيد بعد تطبيق كل شيء)
            $table->integer('leave_balance_after')->default(0)->comment('رصيد الإجازات المتراكم بعد دفع هذا الراتب، بعد خصم الإجازات وحساب الخصومات المالية (لا يقل عن 0)');

            $table->enum('status', ['pending', 'paid', 'cancelled'])->default('pending'); // حالة الراتب
            $table->date('paid_at')->nullable();
            $table->text('notes')->nullable();

            $table->timestamps();

            // فهرس لتسريع البحث حسب الموظف والشهر والسنة
            $table->unique(['employee_id', 'month', 'year'], 'employee_month_year_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payrolls');
    }
};