<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('deductions', function (Blueprint $table) {
            $table->id();

            // ربط الخصم بالموظف
            $table->foreignId('employee_id')
                  ->constrained('employees')
                  ->cascadeOnDelete(); // حذف الخصومات عند حذف الموظف

            $table->enum('type', ['cash', 'in_kind']); // نقدي أو عيني
            $table->string('description');
            $table->decimal('amount', 10, 2);
            $table->date('deduction_date');
            $table->enum('status', ['pending', 'applied', 'cancelled'])->default('pending');
            $table->boolean('is_monthly')->default(false); // تطبيق شهري
            $table->date('end_date')->nullable(); // انتهاء الخصومات الشهرية
            $table->text('notes')->nullable();

            $table->timestamps();

            // فهرس لتسريع استعلامات الموظف وحالة الخصم
            $table->index(['employee_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('deductions');
    }
};
