<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->string('asset_code')->unique();
            $table->string('name');
            $table->string('category');
            $table->date('purchase_date');
            $table->decimal('purchase_cost', 10, 2);
            $table->decimal('current_value', 10, 2);

            // ربط الأصل بالموظف المسؤول (يمكن أن يكون فارغ)
            $table->foreignId('assigned_to')
                  ->nullable()
                  ->constrained('employees')
                  ->nullOnDelete(); // إذا حذف الموظف يتصفّر الحقل

            $table->enum('status', ['available', 'assigned', 'maintenance', 'retired'])->default('available');
            $table->date('warranty_end')->nullable();
            $table->string('location');
            $table->timestamps();

            $table->index('assigned_to'); // لتحسين الاستعلامات حسب الموظف
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('assets');
    }
};
