<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('training_enrollments')) {
            Schema::create('training_enrollments', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('program_id');
                $table->unsignedBigInteger('employee_id');
                $table->string('status')->default('enrolled');
                $table->integer('progress_percentage')->default(0);
                $table->integer('score')->nullable();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->foreign('program_id')->references('id')->on('training_programs')->onDelete('cascade');
                $table->foreign('employee_id')->references('id')->on('employees')->onDelete('cascade');

                $table->unique(['program_id', 'employee_id'], 'unique_program_employee');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('training_enrollments');
    }
};
