<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('training_programs')) {
            Schema::create('training_programs', function (Blueprint $table) {
                $table->id();
                $table->string('title');
                $table->text('description')->nullable();
                $table->string('category')->default('technical');
                $table->unsignedBigInteger('trainer_id')->nullable();
                $table->string('location')->nullable();
                $table->integer('duration')->default(1);
                $table->string('duration_unit')->default('hours');
                $table->integer('capacity')->default(10);
                $table->date('start_date');
                $table->date('end_date');
                $table->string('status')->default('upcoming');
                $table->decimal('completion_percentage', 5, 2)->default(0);
                $table->timestamps();
                $table->softDeletes();

                $table->foreign('trainer_id')->references('id')->on('users')->onDelete('set null');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('training_programs');
    }
};
