<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * إنشاء جدول الموظفين بدون إجبار على وجود الجداول المرتبطة.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            
            // المعلومات الأساسية
            $table->string('employee_id')->unique()->comment('رقم الموظف الفريد');
            $table->string('name')->comment('اسم الموظف الكامل');
            $table->string('email')->unique()->nullable()->comment('البريد الإلكتروني');
            $table->string('phone')->nullable()->comment('رقم الهاتف');
            $table->date('hire_date')->nullable()->comment('تاريخ التوظيف');
            $table->decimal('salary', 10, 2)->nullable()->comment('الراتب الأساسي');
            $table->decimal('incentives', 10, 2)->default(0.00)->nullable() // ✅ تم تغيير 'allowances' إلى 'incentives'
                  ->comment('الحوافز الشهرية (إنتاجية، أداء، مبيعات، ...)'); // ✅ تم تحديث التعليق

            $table->enum('status', ['active', 'inactive', 'pending'])->default('active')
                  ->comment('حالة الموظف: نشط، غير نشط، قيد التوظيف');

            // الروابط الخارجية (أعمدة فقط دون FK الآن)
            $table->unsignedBigInteger('department_id')->nullable()->comment('معرف القسم');
            $table->unsignedBigInteger('position_id')->nullable()->comment('معرف المنصب');
            $table->unsignedBigInteger('role_id')->nullable()->comment('دور النظام للمستخدم المرتبط');
            $table->unsignedBigInteger('user_id')->nullable()->comment('معرف المستخدم المرتبط بالموظف');
            
            // البيانات الشخصية
            $table->date('birth_date')->nullable()->comment('تاريخ الميلاد');
            $table->integer('age')->nullable()->comment('العمر الحالي');
            $table->string('national_id')->nullable()->comment('الرقم الوطني / الهوية');
            $table->string('qualification')->nullable()->comment('المؤهل العلمي');
            $table->text('address')->nullable()->comment('عنوان السكن');
            $table->json('cv_files')->nullable()->comment('مسارات ملفات السيرة الذاتية');
            $table->string('photo')->nullable()->comment('مسار صورة الموظف');

            // أوقات العمل المجدولة
            $table->time('scheduled_check_in')->nullable()->comment('وقت الحضور المجدول');
            $table->time('scheduled_check_out')->nullable()->comment('وقت الانصراف المجدول');

            // توقيتات النظام
            $table->timestamps();
            $table->softDeletes(); // للحذف الناعم

            // فهارس لتسريع الاستعلامات
            $table->index('employee_id');
            $table->index('email');
            $table->index('department_id');
            $table->index('position_id');
            $table->index('role_id');
            $table->index('user_id');
            $table->index('status');
            $table->index('hire_date');
            $table->index('birth_date');
            $table->index('national_id');
        });

        // ⚠️ لا نضيف العلاقات هنا لأن الجداول قد لا تكون موجودة
        // سيتم إضافتها لاحقًا في هجرة منفصلة (مثل update_employees_table_add_foreign_keys)
    }

    /**
     * حذف جدول الموظفين
     */
    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};