<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * إنشاء جدول المستخدمين
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('اسم المستخدم');
            $table->string('email')->unique()->comment('البريد الإلكتروني');
            $table->timestamp('email_verified_at')->nullable()->comment('تاريخ تأكيد البريد الإلكتروني');
            $table->string('password')->comment('كلمة المرور');
            
            // ربط المستخدم بالموظف (سيتم إضافة FK لاحقاً)
            $table->unsignedBigInteger('employee_id')->nullable()->comment('معرف الموظف المرتبط');
            
            $table->enum('status', ['active', 'inactive'])->default('active')->comment('حالة المستخدم');
            $table->timestamp('last_activity')->nullable()->comment('آخر نشاط للمستخدم');
            
            $table->rememberToken();
            $table->timestamps();
            
            // إضافة فهارس
            $table->index('email');
            $table->index('employee_id');
            $table->index('status');
        });
    }

    /**
     * حذف جدول المستخدمين
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};

