<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Payroll;
use App\Models\Employee;

class PayrollFactory extends Factory
{
    protected $model = Payroll::class;

    public function definition()
    {
        return [
            'employee_id' => Employee::factory(),
            'month' => $this->faker->date('Y-m'),
            'basic_salary' => $this->faker->randomFloat(2, 3000, 15000),
            'allowances' => $this->faker->randomFloat(2, 0, 2000),
            'deductions' => $this->faker->randomFloat(2, 0, 1000),
            'bonuses' => $this->faker->randomFloat(2, 0, 3000),
            'total_salary' => $this->faker->randomFloat(2, 2000, 20000),
            'status' => $this->faker->randomElement(['pending', 'paid']),
            'payment_date' => $this->faker->optional()->date(),
            'cash_deductions' => $this->faker->randomFloat(2, 0, 500),
            'in_kind_deductions' => $this->faker->randomFloat(2, 0, 300),
            'loan_deductions' => $this->faker->randomFloat(2, 0, 1000),
        ];
    }
}
