<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\LoanInstallment;
use App\Models\Loan;

class LoanInstallmentFactory extends Factory
{
    protected $model = LoanInstallment::class;

    public function definition()
    {
        return [
            'loan_id' => Loan::factory(),
            'installment_number' => $this->faker->numberBetween(1, 60),
            'amount' => $this->faker->randomFloat(2, 100, 5000),
            'due_date' => $this->faker->date(),
            'paid_date' => $this->faker->optional()->date(),
            'status' => $this->faker->randomElement(['pending', 'paid', 'overdue', 'cancelled']),
            'notes' => $this->faker->optional()->sentence(),
        ];
    }
}
