<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Loan;
use App\Models\Employee;

class LoanFactory extends Factory
{
    protected $model = Loan::class;

    public function definition()
    {
        $amount = $this->faker->randomFloat(2, 1000, 50000);
        $interestRate = $this->faker->randomFloat(2, 0, 20);
        $totalAmount = $amount + ($amount * $interestRate / 100);
        $installmentsCount = $this->faker->numberBetween(1, 60);

        return [
            'employee_id' => Employee::factory(),
            'loan_number' => 'LN' . $this->faker->unique()->numerify('######'),
            'title' => $this->faker->sentence(3),
            'description' => $this->faker->optional()->paragraph(),
            'amount' => $amount,
            'interest_rate' => $interestRate,
            'total_amount' => $totalAmount,
            'installments_count' => $installmentsCount,
            'installment_amount' => $totalAmount / $installmentsCount,
            'start_date' => $this->faker->date(),
            'end_date' => $this->faker->date('Y-m-d', '+5 years'),
            'status' => $this->faker->randomElement(['pending', 'approved', 'active', 'completed', 'cancelled']),
            'approved_by' => null,
            'approved_at' => null,
            'approval_notes' => null,
        ];
    }
}
