<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Leave;
use App\Models\Employee;

class LeaveFactory extends Factory
{
    protected $model = Leave::class;

    public function definition()
    {
        $startDate = $this->faker->date();
        $endDate = $this->faker->date('Y-m-d', '+10 days');

        return [
            'employee_id' => Employee::factory(),
            'leave_type' => $this->faker->randomElement(['annual', 'sick', 'emergency', 'maternity', 'paternity']),
            'start_date' => $startDate,
            'end_date' => $endDate,
            'reason' => $this->faker->sentence(),
            'status' => $this->faker->randomElement(['pending', 'approved', 'rejected']),
            'approved_by' => null,
        ];
    }
}
