<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Employee;

class EmployeeFactory extends Factory
{
    protected $model = Employee::class;

    public function definition()
    {
        return [
            'employee_id' => 'EMP' . $this->faker->unique()->numerify('####'),
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            // Use nullable foreign keys instead of storing text fields
            'position_id' => null,
            'department_id' => null,
            'hire_date' => $this->faker->date(),
            'salary' => $this->faker->randomFloat(2, 3000, 15000),
            'status' => $this->faker->randomElement(['active', 'inactive']),
        ];
    }
}
