<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Deduction;
use App\Models\Employee;

class DeductionFactory extends Factory
{
    protected $model = Deduction::class;

    public function definition()
    {
        return [
            'employee_id' => Employee::factory(),
            'type' => $this->faker->randomElement(['cash', 'in_kind']),
            'description' => $this->faker->sentence(),
            'amount' => $this->faker->randomFloat(2, 100, 5000),
            'deduction_date' => $this->faker->date(),
            'status' => $this->faker->randomElement(['pending', 'applied', 'cancelled']),
            'is_monthly' => $this->faker->boolean(),
            'end_date' => $this->faker->optional()->date(),
            'notes' => $this->faker->optional()->sentence(),
        ];
    }
}
