<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Attendance;
use App\Models\Employee;

class AttendanceFactory extends Factory
{
    protected $model = Attendance::class;

    public function definition()
    {
        return [
            'employee_id' => Employee::factory(),
            'date' => $this->faker->date(),
            'check_in' => $this->faker->time(),
            'check_out' => $this->faker->time(),
            'status' => $this->faker->randomElement(['present', 'absent', 'late', 'leave']),
            'notes' => $this->faker->optional()->sentence(),
        ];
    }
}
