<?php
// Temporary script to clean duplicate Paid Off-day Compensation components
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Clean duplicates for payroll #7
$payrollId = 7;
$components = \App\Models\PayrollSalaryComponent::where('payroll_id', $payrollId)
    ->where('name', 'Paid Off-day Compensation')
    ->get();

echo "Found " . $components->count() . " Paid Off-day Compensation components for payroll #" . $payrollId . "\n";

if ($components->count() > 1) {
    $keepFirst = true;
    foreach ($components as $component) {
        if ($keepFirst) {
            echo "Keeping component ID: " . $component->id . "\n";
            $keepFirst = false;
        } else {
            echo "Deleting duplicate component ID: " . $component->id . "\n";
            $component->delete();
        }
    }
    echo "Cleanup completed.\n";
} else {
    echo "No duplicates found.\n";
}

// Check for other payrolls with duplicates
$allDuplicates = \App\Models\PayrollSalaryComponent::select('payroll_id', 'name')
    ->selectRaw('COUNT(*) as count')
    ->where('name', 'Paid Off-day Compensation')
    ->groupBy('payroll_id', 'name')
    ->having('count', '>', 1)
    ->get();

if ($allDuplicates->count() > 0) {
    echo "\nFound duplicates in other payrolls:\n";
    foreach ($allDuplicates as $duplicate) {
        echo "Payroll #" . $duplicate->payroll_id . ": " . $duplicate->count . " duplicates\n";
        
        // Clean duplicates for this payroll too
        $payrollComponents = \App\Models\PayrollSalaryComponent::where('payroll_id', $duplicate->payroll_id)
            ->where('name', 'Paid Off-day Compensation')
            ->get();
        
        $keepFirst = true;
        foreach ($payrollComponents as $component) {
            if ($keepFirst) {
                $keepFirst = false;
            } else {
                $component->delete();
            }
        }
    }
    echo "Cleaned all duplicates.\n";
} else {
    echo "\nNo duplicates found in other payrolls.\n";
}
