<?php

use Illuminate\Contracts\Console\Kernel;

$app = require __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Kernel::class);

$kernel->bootstrap();

$user = \App\Models\User::where('email', 'admin1@example.com')->first();

if ($user) {
    echo "✅ User admin1@example.com found!\n";
    echo "Role: " . print_r($user->role, true) . "\n";
    echo "hasRole('admin'): " . ($user->hasRole('admin') ? "true" : "false") . "\n";
} else {
    echo "❌ User not found. Available admin users:\n";
    $admins = \App\Models\User::where('email', 'like', '%admin%')->limit(20)->get();
    foreach ($admins as $admin) {
        echo "  {$admin->email}: " . print_r($admin->role, true) . "\n";
    }
}
