<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class SuperAdminAuditLog
{
    /**
     * تسجيل إجراء السوبر أدمن
     */
    public static function log(string $action, string $model, $modelId, array $data = []): void
    {
        $user = Auth::user();
        
        if (!$user) {
            return;
        }

        $logData = [
            'timestamp' => now()->toIso8601String(),
            'super_admin_id' => $user->id,
            'super_admin_email' => $user->email,
            'action' => $action,
            'model' => $model,
            'model_id' => $modelId,
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
            'data' => $data,
        ];

        Log::channel('super_admin')->info('Super Admin Action', $logData);
    }

    /**
     * تسجيل إنشاء شركة
     */
    public static function logCompanyCreated($company): void
    {
        self::log('CREATE', 'Company', $company->id, [
            'name' => $company->name,
            'email' => $company->email,
            'status' => $company->status,
        ]);
    }

    /**
     * تسجيل تحديث شركة
     */
    public static function logCompanyUpdated($company, array $changes): void
    {
        self::log('UPDATE', 'Company', $company->id, [
            'name' => $company->name,
            'changes' => $changes,
        ]);
    }

    /**
     * تسجيل حذف شركة
     */
    public static function logCompanyDeleted($company): void
    {
        self::log('DELETE', 'Company', $company->id, [
            'name' => $company->name,
            'email' => $company->email,
        ]);
    }

    /**
     * تسجيل إنشاء مستخدم
     */
    public static function logUserCreated($user, $company): void
    {
        self::log('CREATE', 'User', $user->id, [
            'name' => $user->name,
            'email' => $user->email,
            'role' => $user->role,
            'company_id' => $company->id,
            'company_name' => $company->name,
        ]);
    }

    /**
     * تسجيل تحديث مستخدم
     */
    public static function logUserUpdated($user, $company, array $changes): void
    {
        self::log('UPDATE', 'User', $user->id, [
            'name' => $user->name,
            'email' => $user->email,
            'company_id' => $company->id,
            'company_name' => $company->name,
            'changes' => $changes,
        ]);
    }

    /**
     * تسجيل حذف مستخدم
     */
    public static function logUserDeleted($user, $company): void
    {
        self::log('DELETE', 'User', $user->id, [
            'name' => $user->name,
            'email' => $user->email,
            'company_id' => $company->id,
            'company_name' => $company->name,
        ]);
    }

    /**
     * تسجيل محاكاة الدخول
     */
    public static function logImpersonation($user, $company): void
    {
        self::log('IMPERSONATE', 'User', $user->id, [
            'impersonated_user' => $user->name,
            'impersonated_email' => $user->email,
            'company_id' => $company->id,
            'company_name' => $company->name,
        ]);
    }

    /**
     * تسجيل إنهاء محاكاة الدخول
     */
    public static function logStopImpersonation($user): void
    {
        self::log('STOP_IMPERSONATE', 'User', $user->id, [
            'user_name' => $user->name,
            'user_email' => $user->email,
        ]);
    }
}
