<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class CompanyScope implements Scope
{
    /**
     * تطبيق الـ scope على الاستعلام
     * يقيد الاستعلام ليعيد فقط السجلات التي تنتمي للشركة الحالية
     */
    public function apply(Builder $builder, Model $model): void
    {
        // إذا كان المستخدم super_admin، لا تطبق الـ scope
        if (auth()->check() && auth()->user()->role === 'super_admin') {
            return;
        }

        // إذا كان هناك شركة نشطة في الجلسة أو من المستخدم الحالي
        if (auth()->check() && auth()->user()->company_id) {
            $builder->where($model->getTable() . '.company_id', auth()->user()->company_id);
        }
    }
}
